/*
struct cchash
{
    size_t operator()(vector<uint32_t> const& vec) const
    {
        size_t seed = vec.size();
        for(auto x : vec)
        {
            x = ((x >> 16) ^ x) * 0x45d9f3b;
            x = ((x >> 16) ^ x) * 0x45d9f3b;
            x = (x >> 16) ^ x;
            seed ^= x + 0x9e3779b9 + (seed << 6) + (seed >> 2);
        }
        return seed;
    }
};

struct custom_hash {
    static uint64_t splitmix64(uint64_t x) {
        // http://xorshift.di.unimi.it/splitmix64.c
        x += 0x9e3779b97f4a7c15;
        x = (x ^ (x >> 30)) * 0xbf58476d1ce4e5b9;
        x = (x ^ (x >> 27)) * 0x94d049bb133111eb;
        return x ^ (x >> 31);
    }

    size_t operator()(uint64_t x) const {
        static const uint64_t FIXED_RANDOM = chrono::steady_clock::now().time_since_epoch().count();
        return splitmix64(x + FIXED_RANDOM);
    }
};

*/

/*

struct FT
{
    /// point update and range sum
    ll fw[MAXN];
    ll n;

    void add(ll pos, ll val)
    {
        for(;pos<n;pos|=pos+1)
            fw[pos]+=val;
    }

    void init(vector<ll>& a)
    {
        n=a.sz;
        ff(i,0,a.sz)
        add(i,a[i]);
    }

    ll sum(ll pos)
    {
        ll ans = 0;
        for(;pos>=0;pos=(pos&(pos+1))-1)
            ans+=fw[pos];
        return ans;
    }

    ll sum_lr(ll l, ll r)
    {
        return sum(r)-sum(l-1);
    }
    /// point update and point min
    ll n;
    vector<ll> fw = vector<ll>(MAXN,INF);

    void update(ll pos, ll val)
    {
        for(pos;pos<n;pos|=pos+1)
            fw[pos]=min(fw[pos],val);
    }

    void init(vector<ll>& a)
    {
        n=a.sz;
        ff(i,0,n) update(i,a[i]);
    }

    ll getmin(ll pos)
    {
        ll ans = INF;
        for(;pos>=0;pos=(pos&(pos+1))-1)
            ans=min(ans,fw[pos]);
        return ans;
    }
    /// range update and range sum
    ll n;
    vector<ll> fw1 = vector<ll>(MAXN);
    vector<ll> fw2 = vector<ll>(MAXN);

    void add(vector<ll>& fw, ll pos, ll val)
    {
        for(; pos<=n; pos+=pos&-pos)
            fw[pos]+=val;
    }

    void init(vector<ll>& a)
    {
        n=a.sz-1;
        fff(i,1,n)
        {
            range_add(i,i,a[i]);
        }
    }

    void range_add(ll l, ll r, ll x)
    {
        add(fw1, l, x);
        add(fw1, r+1, -x);
        add(fw2, l, x*(l-1));
        add(fw2, r+1, -x*r);
    }

    ll sum(vector<ll>& fw, ll pos)
    {
        ll ans = 0;
        for(; pos>0; pos-=pos&-pos)
            ans+=fw[pos];
        return ans;
    }

    ll prefix_sum(ll pos)
    {
        return sum(fw1,pos)*pos-sum(fw2,pos);
    }

    ll range_sum(ll l, ll r)
    {
        return prefix_sum(r)-prefix_sum(l-1);
    }
    //vector<vector<ll>> fw = vector<vector<ll>>(MAXN,vector<ll>(MAXN));




};
*/

/*

int sgn(ll x) { return x > 0 ? 1 : x < 0 ? -1 : 0; }

int half(array<ll,2> x) { return x[1] != 0 ? sgn(x[1]) : -sgn(x[0]); }

ll cross(array<ll,2> a, array<ll,2> b)  { return a[0]*b[1]-a[1]*b[0]; }

bool Poredi(array<ll,2> a, array<ll,2> b) { int A = half(a), B = half(b);
	return A == B ? cross(a,b) < 0 : A > B; }

struct pt
{
    double x,y;
    pt (double x, double y)
    {
        this->x=x;
        this->y=y;
    }
    pt operator- (pt p)
    {
        return pt(this->x-p.x,this->y-p.y);
    }
};

struct vec
{
    double x,y;
    vec (pt p1, pt p2)
    {
        pt res = p2-p1;
        this->x=res.x;
        this->y=res.y;
    }
    vec(pt p)
    {
        this->x=p.x;
        this->y=p.y;
    }
    double len()
    {
        return sqrt(x*x+y*y);
    }
    void scale_up(double cst)
    {
        this->x*=cst;
        this->y*=cst;
    }
    void scale_down(double cst)
    {
        this->x/=cst;
        this->y/=cst;
    }
    vec operator- (vec v)
    {
        return vec(pt(this->x-v.x,this->y-v.y));
    }
    vec operator+ (vec v)
    {
        return vec(pt(this->x+v.x,this->y+v.y));
    }
    double operator* (vec v)
    {
        return this->x*v.x+this->y*v.y;
    }
    double operator^ (vec v)
    {
        return this->x*v.y-this->y*v.x;
    }
    double ugao(vec v)
    {
        double cross = (*this)^v;
        double dot = (*this)*v;
        double ugao = atan2(cross,dot);
        return abs(ugao)*180/PI;
    }
};
*/

/*
__int128 read() {
    __int128 x = 0, f = 1;
    char ch = getchar();
    while (ch < '0' || ch > '9') {
        if (ch == '-') f = -1;
        ch = getchar();
    }
    while (ch >= '0' && ch <= '9') {
        x = x * 10 + ch - '0';
        ch = getchar();
    }
    return x * f;
}
void print(__int128 x) {
    if (x < 0) {
        putchar('-');
        x = -x;
    }
    if (x > 9) print(x / 10);
    putchar(x % 10 + '0');
}
*/

/*
ll a[MAXN];
ll s[4*MAXN];
ll lazy[4*MAXN];

struct ST
{
    void push(ll v, ll l, ll r)
    {
        if(lazy[v]!=0)
        {
            s[v]+=lazy[v];
            if(l!=r)
            {
                lazy[2*v]+=lazy[v];
                lazy[2*v+1]+=lazy[v];
            }
            lazy[v]=0;
        }
    }
    void pull(ll v)
    {
        s[v]=min(s[2*v],s[2*v+1]);
    }
    void build(ll v, ll l, ll r)
    {
        lazy[v]=0;
        if(l==r)
        {
            s[v]=a[l];
        }
        else
        {
            ll mid = (l+r)/2;
            build(2*v,l,mid);
            build(2*v+1,mid+1,r);
            pull(v);
        }
    }
    void update(ll v, ll tl, ll tr, ll l, ll r, ll val)
    {
        push(v,tl,tr);
        if(tl>r || tr<l)
            return;
        if(tl>=l && tr<=r)
        {
            lazy[v]+=val;
            push(v,tl,tr);
            return;
        }
        ll mid = (tl+tr)/2;
        update(2*v,tl,mid,l,r,val);
        update(2*v+1,mid+1,tr,l,r,val);
        pull(v);
    }
    ll query(ll v, ll L, ll R, ll l, ll r)
    {
        push(v,L,R);
        if(L>r || R<l)
            return INF;
        if(L>=l && R<=r)
        {
            return s[v];
        }
        ll mid = (L+R)/2;
        return min(query(2*v,L,mid,l,r),query(2*v+1,mid+1,R,l,r));
    }
};
*/

/*
ll block_size=550;

struct Query {
    ll l, r, idx;
    bool operator<(Query other)
    {
        if(l / block_size != other.l / block_size)
            return mp(l,r)<mp(other.l,other.r);
        return(l / block_size & 1) ? (r < other.r) : (r > other.r);
    }
};


ll a[MAXN], cnt[MAXN], ans[MAXN], freq[MAXN], maxi;
Query v[MAXN];

void remov(ll idx)
{
    if(idx==0) return;
    freq[cnt[a[idx]]]--;
    if(freq[maxi]==0)
        maxi--;
    cnt[a[idx]]--;
    if(cnt[a[idx]]!=0)
        freq[cnt[a[idx]]]++;
}

void ad(ll idx)
{
    if(idx==0) return;
    if(cnt[a[idx]]!=0)
        freq[cnt[a[idx]]]--;
    cnt[a[idx]]++;
    freq[cnt[a[idx]]]++;
    if(cnt[a[idx]]>maxi)
        maxi=cnt[a[idx]];
}


int main()
{
    SPED;
    ll n;
    while(true)
    {
        cin >> n;
        if(n==0)
            break;
        ll q;
        cin >> q;
        maxi = 0;
        memset(cnt,0,sizeof(cnt));
        memset(freq,0,sizeof(freq));
        fff(i,1,n)
        {
            cin >> a[i];
            a[i]+=100000;
        }
        fff(i,1,q)
        {
            cin >> v[i].l >> v[i].r;
            v[i].idx=i;
        }
        sort(v+1,v+1+q);
        ll curl = 0;
        ll curr = 0;
        fff(i,1,q)
        {
            ll L = v[i].l;
            ll R = v[i].r;
            while(curl < L) remov(curl++);
            while(curl > L) ad(--curl);
            while(curr < R) ad(++curr);
            while(curr > R) remov(curr--);
            ans[v[i].idx]=maxi;
        }
        fff(i,1,q)
        cout << ans[i] << "\n";

    }
    return 0;
}
*/

/*
struct SegementTree
{
    vector<ll> segment_tree = vector<ll>(4*MAXN + 5);
    vector<ll> a;
    void buildsum(ll v,ll l, ll r)
    {
        if(l==r)
        {
            segment_tree[v]=a[l];
        }
        else
        {
            ll mid = (l+r)/2;
            buildsum(2*v,l,mid);
            buildsum(2*v+1,mid+1,r);
            segment_tree[v]=segment_tree[2*v]+segment_tree[2*v+1];
        }
    }
    void buildmin(ll v,ll l, ll r)
    {
        if(l==r)
        {
            segment_tree[v]=a[l];
        }
        else
        {
            ll mid=(l+r)/2;
            buildmin(2*v,l,mid);
            buildmin(2*v+1,mid+1,r);
            segment_tree[v]=min(segment_tree[2*v],segment_tree[2*v+1]);
        }
    }
    void buildmax(ll v,ll l, ll r)
    {
        if(l==r)
        {
            segment_tree[v]=a[l];
        }
        else
        {
            ll mid=(l+r)/2;
            buildmax(2*v,l,mid);
            buildmax(2*v+1,mid+1,r);
            segment_tree[v]=max(segment_tree[2*v],segment_tree[2*v+1]);
        }
    }
    void updatesum(ll v, ll indeks, ll val, ll l,ll r)
    {
        if(l==r)
        {
            segment_tree[v]=val;
        }
        else
        {
            ll mid=(l+r)/2;
            if(indeks<=mid)
                updatesum(2*v,indeks,val,l,mid);
            else
                updatesum(2*v+1,indeks,val,mid+1,r);
            segment_tree[v]=segment_tree[2*v]+segment_tree[2*v+1];
        }

    }
    void updatemin(ll v, ll indeks, ll val, ll l,ll r)
    {
        if(l==r)
        {
            segment_tree[v]=val;
        }
        else
        {
            ll mid=(l+r)/2;
            if(indeks<=mid)
                updatemin(2*v,indeks,val,l,mid);
            else
                updatemin(2*v+1,indeks,val,mid+1,r);
            segment_tree[v]=min(segment_tree[2*v],segment_tree[2*v+1]);
        }
    }
    void updatemax(ll v, ll indeks, ll val, ll l,ll r)
    {
        if(l==r)
        {
            segment_tree[v]=val;
        }
        else
        {
            ll mid=(l+r)/2;
            if(indeks<=mid)
                updatemax(2*v,indeks,val,l,mid);
            else
                updatemax(2*v+1,indeks,val,mid+1,r);
            segment_tree[v]=max(segment_tree[2*v],segment_tree[2*v+1]);
        }
    }
    ll query_sum(ll v,ll tl, ll tr, ll l, ll r)
    {
        if(l>r)
            return 0;
        if(tl==l && tr==r)
            return segment_tree[v];
        ll mid = (tl+tr)/2;
        return query_sum(v*2,tl,mid,l,min(r,mid))+query_sum(v*2+1,mid+1,tr,max(l,mid+1),r);
    }
    ll query_min(ll v,ll tl, ll tr, ll l, ll r)
    {
        if(l>r)
            return INF;
        if(tl==l && tr==r)
            return segment_tree[v];
        ll mid = (tl+tr)/2;
        return min(query_min(v*2,tl,mid,l,min(r,mid)),query_min(v*2+1,mid+1,tr,max(l,mid+1),r));
    }
    ll query_max(ll v,ll tl, ll tr, ll l, ll r)
    {
        if(l>r)
            return 0;
        if(tl==l && tr==r)
            return segment_tree[v];
        ll mid = (tl+tr)/2;
        return max(query_max(v*2,tl,mid,l,min(r,mid)),query_max(v*2+1,mid+1,tr,max(l,mid+1),r));
    }
};


struct ST
{
    vector<ll> a;
    ll s[4*MAXN];
    void build(ll v, ll l, ll r)
    {
        if(l==r)
        {
            s[v]=a[l];
        }
        else
        {
            ll mid = (l+r)/2;
            build(2*v,l,mid);
            build(2*v+1,mid+1,r);
            s[v]=s[2*v]+s[2*v+1];
        }
    }
    void update(ll v, ll tl, ll tr, ll l, ll r)
    {
        if(s[v]==tr-tl+1)
            return;
        if(tl==tr)
        {
            s[v]=(ll)sqrt(s[v]);
        }
        else
        {
            ll mid = (tl+tr)/2;
            if(l<=mid)
                update(2*v,tl,mid,l,min(r,mid));
            if(r>mid)
                update(2*v+1,mid+1,tr,max(l,mid+1),r);
            s[v]=s[2*v]+s[2*v+1];
        }
    }
    ll query(ll v, ll L, ll R, ll l, ll r)
    {
        if(L>r || R<l)
            return 0;
        if(L>=l && R<=r)
            return s[v];
        ll mid = (L+R)/2;
        ll res = 0;
        if(l<=mid)
            res = query(2*v,L,mid,l,min(r,mid));
        if(r>mid)
            res+=query(2*v+1,mid+1,R,max(l,mid+1),r);
        return res;
    }
};
*/

/*
struct UF_Cvor
{
    ll roditelj;
    ll rang;
};

void UF_Init(vector<UF_Cvor>& uf)
{
    ff(i,0,uf.sz)
    {
        uf[i].roditelj = i;
        uf[i].rang = 0;
    }
}

ll UF_Find(vector<UF_Cvor>& uf, ll i)
{
    if(i == uf[i].roditelj)
        return i;
    return uf[i].roditelj = UF_Find(uf,uf[i].roditelj);
}

bool UF_Union(vector<UF_Cvor>& uf, ll v1, ll v2)
{
    ll v1koren = UF_Find(uf, v1);
    ll v2koren = UF_Find(uf, v2);
    if (v1koren == v2koren)
        return false;
    if (uf[v1koren].rang < uf[v2koren].rang)
        uf[v1koren].roditelj = v2koren;
    else if (uf[v1koren].rang > uf[v2koren].rang)
        uf[v2koren].roditelj = v1koren;
    else
    {
        uf[v2koren].roditelj = v1koren;
        uf[v1koren].rang++;
    }
    return true;
}

typedef ll Cvor;
typedef double Duzina;
typedef tuple<Duzina, Cvor, Cvor> Grana;



struct UF
{
    vector<int> e;
    UF(int n) : e(n, -1) {}
	bool sameSet(int a, int b) { return find(a) == find(b); }
	int size(int x) { return -e[find(x)]; }
	int find(int x) { return e[x] < 0 ? x : e[x] = find(e[x]); }
	bool join(int a, int b) {
		a = find(a), b = find(b);
		if (a == b) return false;
		if (e[a] > e[b]) swap(a, b);
		e[a] += e[b]; e[b] = a;
		return true;
	}
};
*/

/*
struct Factorizer {
	// Factorizer factorizer(prec_n, sp_bound, rng_seed);
	//    prec_n is the bound for sieve (inclusive)
	//    all numbers will first be checked on primes <= sp_bound (if prec_n >= sp_bound)
	//    factorization for one number ~1e18 takes ~13ms

	vector<int> min_prime;
	vector<int> primes;
	int prec_n;
	int sp_bound;

	Factorizer(int prec_n = 100, int sp_bound = 100, int64_t rng_seed = -1) :
		prec_n(max(prec_n, 3)),
		sp_bound(sp_bound),
		rng(rng_seed != -1 ? rng_seed : chrono::steady_clock::now().time_since_epoch().count()) {
		min_prime.assign(prec_n + 1, -1);
		for (int i = 2; i <= prec_n; ++i) {
			if (min_prime[i] == -1) {
				min_prime[i] = i;
				primes.push_back(i);
			}
			int k = min_prime[i];
			for (int j : primes) {
				if (j * i > prec_n) break;
				min_prime[i * j] = j;
				if (j == k) break;
			}
		}

	}

	bool is_prime(int64_t n, bool check_small = true) {
		if (n <= prec_n)
			return min_prime[n] == n;

		if (check_small) {
			for (int p : primes) {
				if (p > sp_bound || (int64_t)p * p > n) break;
				if (n % p == 0) return false;
			}
		}

		int s = 0;
		int64_t d = n - 1;
		while (d % 2 == 0) {
			++s;
			d >>= 1;
		}
		for (int64_t a : {2, 325, 9375, 28178, 450775, 9780504, 1795265022}) {
			if (a >= n) break;
			int64_t x = mpow_long(a, d, n);
			if (x == 1 || x == n - 1)
				continue;
			bool composite = true;
			for (int i = 0; i < s - 1; ++i) {
				x = mul_mod(x, x, n);
				if (x == 1)
					return false;
				if (x == n - 1) {
					composite = false;
					break;
				}
			}
			if (composite)
				return false;
		}
		return true;
	}

	vector<pair<int64_t, int>> factorize(int64_t n, bool check_small = true) {
		vector<pair<int64_t, int>> res;
		if (check_small) {
			for (int p : primes) {
				if (p > sp_bound) break;
				if ((int64_t)p * p > n) break;
				if (n % p == 0) {
					res.emplace_back(p, 0);
					while (n % p == 0) {
						n /= p;
						res.back().second++;
					}
				}
			}
		}

		if (n == 1) return res;
		if (is_prime(n, false)) {
			res.emplace_back(n, 1);
			return res;
		}

		if (n <= prec_n) {
			while (n != 1) {
				int d = min_prime[n];
				if (res.empty() || res.back().first != d)
					res.emplace_back(d, 0);
				res.back().second++;
				n /= d;
			}
			return res;

		}
		int cnt;
		int64_t d = get_divisor(n);
		auto a = factorize(d, false);
		for (auto p : a) {
			p.second = 0;
			while (n % p.first == 0) {
				n /= p.first;
				++p.second;
			}
		}
		auto b = factorize(n, false);

		int ia = 0, ib = 0;
		while (ia < a.size() || ib < b.size()) {
			bool choosea;
			if (ia == a.size()) choosea = false;
			else if (ib == b.size()) choosea = true;
			else if (a[ia].first <= b[ib].first) choosea = true;
			else choosea = false;

			res.push_back(choosea ? a[ia++] : b[ib++]);
		}
		return res;
	}

private:
	mt19937_64 rng;
	int64_t rnd(int64_t l, int64_t r) {
		return uniform_int_distribution<int64_t>(l, r)(rng);
	}

	int64_t mpow_long(int64_t a, int64_t p, int64_t mod) {
		int64_t res = 1;
		while (p) {
			if (p & 1) res = mul_mod(res, a, mod);
			p >>= 1;
			a = mul_mod(a, a, mod);
		}
		return res;
	}

	int64_t mul_mod(int64_t a, int64_t b, int64_t mod) {
		int64_t res = a * b - mod * (int64_t)((long double)1 / mod * a * b);
		if (res < 0) res += mod;
		if (res >= mod) res -= mod;
		return res;
	}
	int64_t get_divisor(int64_t n) {
		auto f = [&](int64_t x) -> int64_t {
			int64_t res = mul_mod(x, x, n) + 1;
			if (res == n) res = 0;
			return res;
		};

		while (true) {
			int64_t x = rnd(1, n - 1);
			int64_t y = f(x);
			while (x != y) {
				int64_t d = __gcd(n, abs(x - y));
				if (d == 0)
					break;
				else if (d != 1)
					return d;
				x = f(x);
				y = f(f(y));
			}
		}
	}
};
*/

#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/rope>

#define mp make_pair
#define mt make_tuple
#define sz size()
#define pb push_back
#define SPED ios_base::sync_with_stdio(false);cin.tie(0);cout.tie(0);cerr.tie(0)
#define all(x) (x).begin(),(x).end()
#define allr(x) (x).rbegin(),(x).rend()
#define inv(n) power((n), mod - 2)
#define ff(i,a,b) for (long long (i) = (a); (i) < (b); (i)++)
#define fff(i,a,b) for (long long (i) = (a); (i) <= b; (i)++)
#define bff(i,a,b) for (long long (i) = (b)-1; (i) >= (a); (i)--)
#define bfff(i,a,b) for (long long (i) = (b); (i) >= (a); (i)--)
#define sum_overflow(a,b) __builtin_add_overflow_p ((a), (b), (__typeof__ ((a) + (b))) 0)
#define mul_overflow(a,b) __builtin_mul_overflow_p ((a), (b), (__typeof__ ((a) * (b))) 0)
#define popcount(x) __builtin_popcountll(x)
#define PI 3.14159265358979323846

using namespace std;
using namespace __gnu_pbds;
using namespace __gnu_cxx;

typedef long long int ll;
typedef long double ld;
typedef unsigned long long int ull;
typedef pair<ll,ll> pll;
typedef vector<vector<ll>> graf;
typedef vector<vector<array<ll,2>>> graf_t;
typedef vector<vector<array<double,2>>> graf_d;
typedef array<ll,3> all;
typedef array<double,3> add;

const ll mod = 1e9+7;
const ll MOD = 998244353;
const ll MAXN = 2e5+10;
const ll INF = 1e18;
const ld EPS = 1e-9;

template <class T> using ordered_set = tree<T, null_type,less<T>, rb_tree_tag,tree_order_statistics_node_update>;
template <class T> using ordered_multiset = tree<T, null_type,less_equal<T>, rb_tree_tag,tree_order_statistics_node_update>;

int main()
{
    SPED;
    ll n,m;
    cin >> n >> m;
    vector<ll> a(m);
    ll mn = 0;
    ff(i,0,m){
    cin >> a[i];
    mn+=a[i];
    }
    ll maxj = 1LL << 30;
    for(ll j =1;j<=maxj;j*=2)
    {
        ll cnt = 0;
        ff(i,0,m)
        {
            if(j&a[i])
                cnt++;
        }
        mn=min(mn,mn-cnt*j+(m-cnt)*j);
    }
    cout << mn << "\n";
    return 0;
}